package zio.aws.kafka.model
import scala.jdk.CollectionConverters.*
sealed trait TargetCompressionType {
  def unwrap: software.amazon.awssdk.services.kafka.model.TargetCompressionType
}
object TargetCompressionType {
  def wrap(
      value: software.amazon.awssdk.services.kafka.model.TargetCompressionType
  ): zio.aws.kafka.model.TargetCompressionType = value match {
    case software.amazon.awssdk.services.kafka.model.TargetCompressionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kafka.model.TargetCompressionType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.kafka.model.TargetCompressionType.GZIP =>
      val r = GZIP
      r
    case software.amazon.awssdk.services.kafka.model.TargetCompressionType.SNAPPY =>
      val r = SNAPPY
      r
    case software.amazon.awssdk.services.kafka.model.TargetCompressionType.LZ4 =>
      val r = LZ4
      r
    case software.amazon.awssdk.services.kafka.model.TargetCompressionType.ZSTD =>
      val r = ZSTD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kafka.model.TargetCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.TargetCompressionType =
      software.amazon.awssdk.services.kafka.model.TargetCompressionType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.kafka.model.TargetCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.TargetCompressionType =
      software.amazon.awssdk.services.kafka.model.TargetCompressionType.NONE
  }
  case object GZIP extends zio.aws.kafka.model.TargetCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.TargetCompressionType =
      software.amazon.awssdk.services.kafka.model.TargetCompressionType.GZIP
  }
  case object SNAPPY extends zio.aws.kafka.model.TargetCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.TargetCompressionType =
      software.amazon.awssdk.services.kafka.model.TargetCompressionType.SNAPPY
  }
  case object LZ4 extends zio.aws.kafka.model.TargetCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.TargetCompressionType =
      software.amazon.awssdk.services.kafka.model.TargetCompressionType.LZ4
  }
  case object ZSTD extends zio.aws.kafka.model.TargetCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.TargetCompressionType =
      software.amazon.awssdk.services.kafka.model.TargetCompressionType.ZSTD
  }
}
