package zio.aws.kafka.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__boolean, __string, __timestampIso8601}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ReplicatorSummary(
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    currentVersion: Optional[__string] = Optional.Absent,
    isReplicatorReference: Optional[__boolean] = Optional.Absent,
    kafkaClustersSummary: Optional[
      Iterable[zio.aws.kafka.model.KafkaClusterSummary]
    ] = Optional.Absent,
    replicationInfoSummaryList: Optional[
      Iterable[zio.aws.kafka.model.ReplicationInfoSummary]
    ] = Optional.Absent,
    replicatorArn: Optional[__string] = Optional.Absent,
    replicatorName: Optional[__string] = Optional.Absent,
    replicatorResourceArn: Optional[__string] = Optional.Absent,
    replicatorState: Optional[zio.aws.kafka.model.ReplicatorState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ReplicatorSummary = {
    import ReplicatorSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ReplicatorSummary
      .builder()
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(currentVersion.map(value => value: java.lang.String))(
        _.currentVersion
      )
      .optionallyWith(
        isReplicatorReference.map(value => value: java.lang.Boolean)
      )(_.isReplicatorReference)
      .optionallyWith(
        kafkaClustersSummary.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.kafkaClustersSummary)
      .optionallyWith(
        replicationInfoSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationInfoSummaryList)
      .optionallyWith(replicatorArn.map(value => value: java.lang.String))(
        _.replicatorArn
      )
      .optionallyWith(replicatorName.map(value => value: java.lang.String))(
        _.replicatorName
      )
      .optionallyWith(
        replicatorResourceArn.map(value => value: java.lang.String)
      )(_.replicatorResourceArn)
      .optionallyWith(replicatorState.map(value => value.unwrap))(
        _.replicatorState
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ReplicatorSummary.ReadOnly =
    zio.aws.kafka.model.ReplicatorSummary.wrap(buildAwsValue())
}
object ReplicatorSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ReplicatorSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ReplicatorSummary =
      zio.aws.kafka.model.ReplicatorSummary(
        creationTime.map(value => value),
        currentVersion.map(value => value),
        isReplicatorReference.map(value => value),
        kafkaClustersSummary.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicationInfoSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicatorArn.map(value => value),
        replicatorName.map(value => value),
        replicatorResourceArn.map(value => value),
        replicatorState.map(value => value)
      )
    def creationTime: Optional[__timestampIso8601]
    def currentVersion: Optional[__string]
    def isReplicatorReference: Optional[__boolean]
    def kafkaClustersSummary
        : Optional[List[zio.aws.kafka.model.KafkaClusterSummary.ReadOnly]]
    def replicationInfoSummaryList
        : Optional[List[zio.aws.kafka.model.ReplicationInfoSummary.ReadOnly]]
    def replicatorArn: Optional[__string]
    def replicatorName: Optional[__string]
    def replicatorResourceArn: Optional[__string]
    def replicatorState: Optional[zio.aws.kafka.model.ReplicatorState]
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCurrentVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getIsReplicatorReference: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("isReplicatorReference", isReplicatorReference)
    def getKafkaClustersSummary: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.KafkaClusterSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("kafkaClustersSummary", kafkaClustersSummary)
    def getReplicationInfoSummaryList: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.ReplicationInfoSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "replicationInfoSummaryList",
      replicationInfoSummaryList
    )
    def getReplicatorArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("replicatorArn", replicatorArn)
    def getReplicatorName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("replicatorName", replicatorName)
    def getReplicatorResourceArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("replicatorResourceArn", replicatorResourceArn)
    def getReplicatorState
        : ZIO[Any, AwsError, zio.aws.kafka.model.ReplicatorState] =
      AwsError.unwrapOptionField("replicatorState", replicatorState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ReplicatorSummary
  ) extends zio.aws.kafka.model.ReplicatorSummary.ReadOnly {
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val currentVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.currentVersion())
      .map(value => value: __string)
    override val isReplicatorReference: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isReplicatorReference())
        .map(value => value: __boolean)
    override val kafkaClustersSummary
        : Optional[List[zio.aws.kafka.model.KafkaClusterSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kafkaClustersSummary())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.KafkaClusterSummary.wrap(item)
          }.toList
        )
    override val replicationInfoSummaryList
        : Optional[List[zio.aws.kafka.model.ReplicationInfoSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInfoSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.ReplicationInfoSummary.wrap(item)
          }.toList
        )
    override val replicatorArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.replicatorArn())
      .map(value => value: __string)
    override val replicatorName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.replicatorName())
      .map(value => value: __string)
    override val replicatorResourceArn: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicatorResourceArn())
        .map(value => value: __string)
    override val replicatorState
        : Optional[zio.aws.kafka.model.ReplicatorState] = zio.aws.core.internal
      .optionalFromNullable(impl.replicatorState())
      .map(value => zio.aws.kafka.model.ReplicatorState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ReplicatorSummary
  ): zio.aws.kafka.model.ReplicatorSummary.ReadOnly = new Wrapper(impl)
}
