package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeClusterOperationV2Response(
    clusterOperationInfo: Optional[zio.aws.kafka.model.ClusterOperationV2] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DescribeClusterOperationV2Response = {
    import DescribeClusterOperationV2Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DescribeClusterOperationV2Response
      .builder()
      .optionallyWith(clusterOperationInfo.map(value => value.buildAwsValue()))(
        _.clusterOperationInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.DescribeClusterOperationV2Response.ReadOnly =
    zio.aws.kafka.model.DescribeClusterOperationV2Response.wrap(buildAwsValue())
}
object DescribeClusterOperationV2Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DescribeClusterOperationV2Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DescribeClusterOperationV2Response =
      zio.aws.kafka.model.DescribeClusterOperationV2Response(
        clusterOperationInfo.map(value => value.asEditable)
      )
    def clusterOperationInfo
        : Optional[zio.aws.kafka.model.ClusterOperationV2.ReadOnly]
    def getClusterOperationInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ClusterOperationV2.ReadOnly] =
      AwsError.unwrapOptionField("clusterOperationInfo", clusterOperationInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DescribeClusterOperationV2Response
  ) extends zio.aws.kafka.model.DescribeClusterOperationV2Response.ReadOnly {
    override val clusterOperationInfo
        : Optional[zio.aws.kafka.model.ClusterOperationV2.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterOperationInfo())
        .map(value => zio.aws.kafka.model.ClusterOperationV2.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DescribeClusterOperationV2Response
  ): zio.aws.kafka.model.DescribeClusterOperationV2Response.ReadOnly =
    new Wrapper(impl)
}
