package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteReplicatorRequest(
    currentVersion: Optional[__string] = Optional.Absent,
    replicatorArn: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DeleteReplicatorRequest = {
    import DeleteReplicatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DeleteReplicatorRequest
      .builder()
      .optionallyWith(currentVersion.map(value => value: java.lang.String))(
        _.currentVersion
      )
      .replicatorArn(replicatorArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.DeleteReplicatorRequest.ReadOnly =
    zio.aws.kafka.model.DeleteReplicatorRequest.wrap(buildAwsValue())
}
object DeleteReplicatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DeleteReplicatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DeleteReplicatorRequest =
      zio.aws.kafka.model.DeleteReplicatorRequest(
        currentVersion.map(value => value),
        replicatorArn
      )
    def currentVersion: Optional[__string]
    def replicatorArn: __string
    def getCurrentVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getReplicatorArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(replicatorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DeleteReplicatorRequest
  ) extends zio.aws.kafka.model.DeleteReplicatorRequest.ReadOnly {
    override val currentVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.currentVersion())
      .map(value => value: __string)
    override val replicatorArn: __string = impl.replicatorArn(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DeleteReplicatorRequest
  ): zio.aws.kafka.model.DeleteReplicatorRequest.ReadOnly = new Wrapper(impl)
}
