package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{
  __string,
  __stringMin1Max128Pattern09AZaZ09AZaZ0,
  __stringMax1024
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateReplicatorRequest(
    description: Optional[__stringMax1024] = Optional.Absent,
    kafkaClusters: Iterable[zio.aws.kafka.model.KafkaCluster],
    replicationInfoList: Iterable[zio.aws.kafka.model.ReplicationInfo],
    replicatorName: __stringMin1Max128Pattern09AZaZ09AZaZ0,
    serviceExecutionRoleArn: __string,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CreateReplicatorRequest = {
    import CreateReplicatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CreateReplicatorRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .kafkaClusters(kafkaClusters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .replicationInfoList(replicationInfoList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .replicatorName(replicatorName: java.lang.String)
      .serviceExecutionRoleArn(serviceExecutionRoleArn: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CreateReplicatorRequest.ReadOnly =
    zio.aws.kafka.model.CreateReplicatorRequest.wrap(buildAwsValue())
}
object CreateReplicatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CreateReplicatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CreateReplicatorRequest =
      zio.aws.kafka.model.CreateReplicatorRequest(
        description.map(value => value),
        kafkaClusters.map { item =>
          item.asEditable
        },
        replicationInfoList.map { item =>
          item.asEditable
        },
        replicatorName,
        serviceExecutionRoleArn,
        tags.map(value => value)
      )
    def description: Optional[__stringMax1024]
    def kafkaClusters: List[zio.aws.kafka.model.KafkaCluster.ReadOnly]
    def replicationInfoList: List[zio.aws.kafka.model.ReplicationInfo.ReadOnly]
    def replicatorName: __stringMin1Max128Pattern09AZaZ09AZaZ0
    def serviceExecutionRoleArn: __string
    def tags: Optional[Map[__string, __string]]
    def getDescription: ZIO[Any, AwsError, __stringMax1024] =
      AwsError.unwrapOptionField("description", description)
    def getKafkaClusters
        : ZIO[Any, Nothing, List[zio.aws.kafka.model.KafkaCluster.ReadOnly]] =
      ZIO.succeed(kafkaClusters)
    def getReplicationInfoList: ZIO[Any, Nothing, List[
      zio.aws.kafka.model.ReplicationInfo.ReadOnly
    ]] = ZIO.succeed(replicationInfoList)
    def getReplicatorName
        : ZIO[Any, Nothing, __stringMin1Max128Pattern09AZaZ09AZaZ0] =
      ZIO.succeed(replicatorName)
    def getServiceExecutionRoleArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(serviceExecutionRoleArn)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CreateReplicatorRequest
  ) extends zio.aws.kafka.model.CreateReplicatorRequest.ReadOnly {
    override val description: Optional[__stringMax1024] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __stringMax1024)
    override val kafkaClusters
        : List[zio.aws.kafka.model.KafkaCluster.ReadOnly] = impl
      .kafkaClusters()
      .asScala
      .map { item =>
        zio.aws.kafka.model.KafkaCluster.wrap(item)
      }
      .toList
    override val replicationInfoList
        : List[zio.aws.kafka.model.ReplicationInfo.ReadOnly] = impl
      .replicationInfoList()
      .asScala
      .map { item =>
        zio.aws.kafka.model.ReplicationInfo.wrap(item)
      }
      .toList
    override val replicatorName: __stringMin1Max128Pattern09AZaZ09AZaZ0 =
      impl.replicatorName(): __stringMin1Max128Pattern09AZaZ09AZaZ0
    override val serviceExecutionRoleArn: __string =
      impl.serviceExecutionRoleArn(): __string
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CreateReplicatorRequest
  ): zio.aws.kafka.model.CreateReplicatorRequest.ReadOnly = new Wrapper(impl)
}
