package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConnectivityInfo(
    publicAccess: Optional[zio.aws.kafka.model.PublicAccess] = Optional.Absent,
    vpcConnectivity: Optional[zio.aws.kafka.model.VpcConnectivity] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ConnectivityInfo = {
    import ConnectivityInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ConnectivityInfo
      .builder()
      .optionallyWith(publicAccess.map(value => value.buildAwsValue()))(
        _.publicAccess
      )
      .optionallyWith(vpcConnectivity.map(value => value.buildAwsValue()))(
        _.vpcConnectivity
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ConnectivityInfo.ReadOnly =
    zio.aws.kafka.model.ConnectivityInfo.wrap(buildAwsValue())
}
object ConnectivityInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ConnectivityInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ConnectivityInfo =
      zio.aws.kafka.model.ConnectivityInfo(
        publicAccess.map(value => value.asEditable),
        vpcConnectivity.map(value => value.asEditable)
      )
    def publicAccess: Optional[zio.aws.kafka.model.PublicAccess.ReadOnly]
    def vpcConnectivity: Optional[zio.aws.kafka.model.VpcConnectivity.ReadOnly]
    def getPublicAccess
        : ZIO[Any, AwsError, zio.aws.kafka.model.PublicAccess.ReadOnly] =
      AwsError.unwrapOptionField("publicAccess", publicAccess)
    def getVpcConnectivity
        : ZIO[Any, AwsError, zio.aws.kafka.model.VpcConnectivity.ReadOnly] =
      AwsError.unwrapOptionField("vpcConnectivity", vpcConnectivity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ConnectivityInfo
  ) extends zio.aws.kafka.model.ConnectivityInfo.ReadOnly {
    override val publicAccess
        : Optional[zio.aws.kafka.model.PublicAccess.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicAccess())
        .map(value => zio.aws.kafka.model.PublicAccess.wrap(value))
    override val vpcConnectivity
        : Optional[zio.aws.kafka.model.VpcConnectivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConnectivity())
        .map(value => zio.aws.kafka.model.VpcConnectivity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ConnectivityInfo
  ): zio.aws.kafka.model.ConnectivityInfo.ReadOnly = new Wrapper(impl)
}
