package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpcConnectivitySasl(
    scram: Optional[zio.aws.kafka.model.VpcConnectivityScram] = Optional.Absent,
    iam: Optional[zio.aws.kafka.model.VpcConnectivityIam] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.VpcConnectivitySasl = {
    import VpcConnectivitySasl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.VpcConnectivitySasl
      .builder()
      .optionallyWith(scram.map(value => value.buildAwsValue()))(_.scram)
      .optionallyWith(iam.map(value => value.buildAwsValue()))(_.iam)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.VpcConnectivitySasl.ReadOnly =
    zio.aws.kafka.model.VpcConnectivitySasl.wrap(buildAwsValue())
}
object VpcConnectivitySasl {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.VpcConnectivitySasl
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.VpcConnectivitySasl =
      zio.aws.kafka.model.VpcConnectivitySasl(
        scram.map(value => value.asEditable),
        iam.map(value => value.asEditable)
      )
    def scram: Optional[zio.aws.kafka.model.VpcConnectivityScram.ReadOnly]
    def iam: Optional[zio.aws.kafka.model.VpcConnectivityIam.ReadOnly]
    def getScram: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.VpcConnectivityScram.ReadOnly
    ] = AwsError.unwrapOptionField("scram", scram)
    def getIam
        : ZIO[Any, AwsError, zio.aws.kafka.model.VpcConnectivityIam.ReadOnly] =
      AwsError.unwrapOptionField("iam", iam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectivitySasl
  ) extends zio.aws.kafka.model.VpcConnectivitySasl.ReadOnly {
    override val scram
        : Optional[zio.aws.kafka.model.VpcConnectivityScram.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scram())
        .map(value => zio.aws.kafka.model.VpcConnectivityScram.wrap(value))
    override val iam
        : Optional[zio.aws.kafka.model.VpcConnectivityIam.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iam())
        .map(value => zio.aws.kafka.model.VpcConnectivityIam.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectivitySasl
  ): zio.aws.kafka.model.VpcConnectivitySasl.ReadOnly = new Wrapper(impl)
}
