package zio.aws.kafka.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__string, __timestampIso8601}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class VpcConnectionInfoServerless(
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    owner: Optional[__string] = Optional.Absent,
    userIdentity: Optional[zio.aws.kafka.model.UserIdentity] = Optional.Absent,
    vpcConnectionArn: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.VpcConnectionInfoServerless = {
    import VpcConnectionInfoServerless.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.VpcConnectionInfoServerless
      .builder()
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(owner.map(value => value: java.lang.String))(_.owner)
      .optionallyWith(userIdentity.map(value => value.buildAwsValue()))(
        _.userIdentity
      )
      .optionallyWith(vpcConnectionArn.map(value => value: java.lang.String))(
        _.vpcConnectionArn
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.VpcConnectionInfoServerless.ReadOnly =
    zio.aws.kafka.model.VpcConnectionInfoServerless.wrap(buildAwsValue())
}
object VpcConnectionInfoServerless {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.VpcConnectionInfoServerless
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.VpcConnectionInfoServerless =
      zio.aws.kafka.model.VpcConnectionInfoServerless(
        creationTime.map(value => value),
        owner.map(value => value),
        userIdentity.map(value => value.asEditable),
        vpcConnectionArn.map(value => value)
      )
    def creationTime: Optional[__timestampIso8601]
    def owner: Optional[__string]
    def userIdentity: Optional[zio.aws.kafka.model.UserIdentity.ReadOnly]
    def vpcConnectionArn: Optional[__string]
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getOwner: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("owner", owner)
    def getUserIdentity
        : ZIO[Any, AwsError, zio.aws.kafka.model.UserIdentity.ReadOnly] =
      AwsError.unwrapOptionField("userIdentity", userIdentity)
    def getVpcConnectionArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("vpcConnectionArn", vpcConnectionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectionInfoServerless
  ) extends zio.aws.kafka.model.VpcConnectionInfoServerless.ReadOnly {
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val owner: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => value: __string)
    override val userIdentity
        : Optional[zio.aws.kafka.model.UserIdentity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userIdentity())
        .map(value => zio.aws.kafka.model.UserIdentity.wrap(value))
    override val vpcConnectionArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcConnectionArn())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectionInfoServerless
  ): zio.aws.kafka.model.VpcConnectionInfoServerless.ReadOnly = new Wrapper(
    impl
  )
}
