package zio.aws.kafka.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__timestampIso8601, __string}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class VpcConnection(
    vpcConnectionArn: __string,
    targetClusterArn: __string,
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    authentication: Optional[__string] = Optional.Absent,
    vpcId: Optional[__string] = Optional.Absent,
    state: Optional[zio.aws.kafka.model.VpcConnectionState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.VpcConnection = {
    import VpcConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.VpcConnection
      .builder()
      .vpcConnectionArn(vpcConnectionArn: java.lang.String)
      .targetClusterArn(targetClusterArn: java.lang.String)
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(authentication.map(value => value: java.lang.String))(
        _.authentication
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.VpcConnection.ReadOnly =
    zio.aws.kafka.model.VpcConnection.wrap(buildAwsValue())
}
object VpcConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.VpcConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.VpcConnection =
      zio.aws.kafka.model.VpcConnection(
        vpcConnectionArn,
        targetClusterArn,
        creationTime.map(value => value),
        authentication.map(value => value),
        vpcId.map(value => value),
        state.map(value => value)
      )
    def vpcConnectionArn: __string
    def targetClusterArn: __string
    def creationTime: Optional[__timestampIso8601]
    def authentication: Optional[__string]
    def vpcId: Optional[__string]
    def state: Optional[zio.aws.kafka.model.VpcConnectionState]
    def getVpcConnectionArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(vpcConnectionArn)
    def getTargetClusterArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(targetClusterArn)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getAuthentication: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("authentication", authentication)
    def getVpcId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.VpcConnectionState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnection
  ) extends zio.aws.kafka.model.VpcConnection.ReadOnly {
    override val vpcConnectionArn: __string = impl.vpcConnectionArn(): __string
    override val targetClusterArn: __string = impl.targetClusterArn(): __string
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val authentication: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.authentication())
      .map(value => value: __string)
    override val vpcId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: __string)
    override val state: Optional[zio.aws.kafka.model.VpcConnectionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.kafka.model.VpcConnectionState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnection
  ): zio.aws.kafka.model.VpcConnection.ReadOnly = new Wrapper(impl)
}
