package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReplicationInfoSummary(
    sourceKafkaClusterAlias: Optional[__string] = Optional.Absent,
    targetKafkaClusterAlias: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ReplicationInfoSummary = {
    import ReplicationInfoSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ReplicationInfoSummary
      .builder()
      .optionallyWith(
        sourceKafkaClusterAlias.map(value => value: java.lang.String)
      )(_.sourceKafkaClusterAlias)
      .optionallyWith(
        targetKafkaClusterAlias.map(value => value: java.lang.String)
      )(_.targetKafkaClusterAlias)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ReplicationInfoSummary.ReadOnly =
    zio.aws.kafka.model.ReplicationInfoSummary.wrap(buildAwsValue())
}
object ReplicationInfoSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ReplicationInfoSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ReplicationInfoSummary =
      zio.aws.kafka.model.ReplicationInfoSummary(
        sourceKafkaClusterAlias.map(value => value),
        targetKafkaClusterAlias.map(value => value)
      )
    def sourceKafkaClusterAlias: Optional[__string]
    def targetKafkaClusterAlias: Optional[__string]
    def getSourceKafkaClusterAlias: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("sourceKafkaClusterAlias", sourceKafkaClusterAlias)
    def getTargetKafkaClusterAlias: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("targetKafkaClusterAlias", targetKafkaClusterAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ReplicationInfoSummary
  ) extends zio.aws.kafka.model.ReplicationInfoSummary.ReadOnly {
    override val sourceKafkaClusterAlias: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceKafkaClusterAlias())
        .map(value => value: __string)
    override val targetKafkaClusterAlias: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetKafkaClusterAlias())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ReplicationInfoSummary
  ): zio.aws.kafka.model.ReplicationInfoSummary.ReadOnly = new Wrapper(impl)
}
