package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListReplicatorsResponse(
    nextToken: Optional[__string] = Optional.Absent,
    replicators: Optional[Iterable[zio.aws.kafka.model.ReplicatorSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListReplicatorsResponse = {
    import ListReplicatorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListReplicatorsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        replicators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicators)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListReplicatorsResponse.ReadOnly =
    zio.aws.kafka.model.ListReplicatorsResponse.wrap(buildAwsValue())
}
object ListReplicatorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListReplicatorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListReplicatorsResponse =
      zio.aws.kafka.model.ListReplicatorsResponse(
        nextToken.map(value => value),
        replicators.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[__string]
    def replicators
        : Optional[List[zio.aws.kafka.model.ReplicatorSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReplicators: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.ReplicatorSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("replicators", replicators)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListReplicatorsResponse
  ) extends zio.aws.kafka.model.ListReplicatorsResponse.ReadOnly {
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val replicators
        : Optional[List[zio.aws.kafka.model.ReplicatorSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.ReplicatorSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListReplicatorsResponse
  ): zio.aws.kafka.model.ListReplicatorsResponse.ReadOnly = new Wrapper(impl)
}
