package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KafkaCluster(
    amazonMskCluster: zio.aws.kafka.model.AmazonMskCluster,
    vpcConfig: zio.aws.kafka.model.KafkaClusterClientVpcConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.KafkaCluster = {
    import KafkaCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.KafkaCluster
      .builder()
      .amazonMskCluster(amazonMskCluster.buildAwsValue())
      .vpcConfig(vpcConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.KafkaCluster.ReadOnly =
    zio.aws.kafka.model.KafkaCluster.wrap(buildAwsValue())
}
object KafkaCluster {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.KafkaCluster
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.KafkaCluster = zio.aws.kafka.model
      .KafkaCluster(amazonMskCluster.asEditable, vpcConfig.asEditable)
    def amazonMskCluster: zio.aws.kafka.model.AmazonMskCluster.ReadOnly
    def vpcConfig: zio.aws.kafka.model.KafkaClusterClientVpcConfig.ReadOnly
    def getAmazonMskCluster
        : ZIO[Any, Nothing, zio.aws.kafka.model.AmazonMskCluster.ReadOnly] =
      ZIO.succeed(amazonMskCluster)
    def getVpcConfig: ZIO[
      Any,
      Nothing,
      zio.aws.kafka.model.KafkaClusterClientVpcConfig.ReadOnly
    ] = ZIO.succeed(vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.KafkaCluster
  ) extends zio.aws.kafka.model.KafkaCluster.ReadOnly {
    override val amazonMskCluster
        : zio.aws.kafka.model.AmazonMskCluster.ReadOnly =
      zio.aws.kafka.model.AmazonMskCluster.wrap(impl.amazonMskCluster())
    override val vpcConfig
        : zio.aws.kafka.model.KafkaClusterClientVpcConfig.ReadOnly =
      zio.aws.kafka.model.KafkaClusterClientVpcConfig.wrap(impl.vpcConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.KafkaCluster
  ): zio.aws.kafka.model.KafkaCluster.ReadOnly = new Wrapper(impl)
}
