package zio.aws.kafka.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{
  __blob,
  __long,
  __timestampIso8601,
  __string
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationRevisionResponse(
    arn: Optional[__string] = Optional.Absent,
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    revision: Optional[__long] = Optional.Absent,
    serverProperties: Optional[__blob] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionResponse = {
    import DescribeConfigurationRevisionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(revision.map(value => value: java.lang.Long))(_.revision)
      .optionallyWith(
        serverProperties.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.serverProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.DescribeConfigurationRevisionResponse.ReadOnly =
    zio.aws.kafka.model.DescribeConfigurationRevisionResponse
      .wrap(buildAwsValue())
}
object DescribeConfigurationRevisionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DescribeConfigurationRevisionResponse =
      zio.aws.kafka.model.DescribeConfigurationRevisionResponse(
        arn.map(value => value),
        creationTime.map(value => value),
        description.map(value => value),
        revision.map(value => value),
        serverProperties.map(value => value)
      )
    def arn: Optional[__string]
    def creationTime: Optional[__timestampIso8601]
    def description: Optional[__string]
    def revision: Optional[__long]
    def serverProperties: Optional[__blob]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getRevision: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("revision", revision)
    def getServerProperties: ZIO[Any, AwsError, __blob] =
      AwsError.unwrapOptionField("serverProperties", serverProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionResponse
  ) extends zio.aws.kafka.model.DescribeConfigurationRevisionResponse.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val revision: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => value: __long)
    override val serverProperties: Optional[__blob] = zio.aws.core.internal
      .optionalFromNullable(impl.serverProperties())
      .map(value => zio.Chunk.fromArray(value.asByteArrayUnsafe()): __blob)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionResponse
  ): zio.aws.kafka.model.DescribeConfigurationRevisionResponse.ReadOnly =
    new Wrapper(impl)
}
