package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateReplicatorResponse(
    replicatorArn: Optional[__string] = Optional.Absent,
    replicatorName: Optional[__string] = Optional.Absent,
    replicatorState: Optional[zio.aws.kafka.model.ReplicatorState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CreateReplicatorResponse = {
    import CreateReplicatorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CreateReplicatorResponse
      .builder()
      .optionallyWith(replicatorArn.map(value => value: java.lang.String))(
        _.replicatorArn
      )
      .optionallyWith(replicatorName.map(value => value: java.lang.String))(
        _.replicatorName
      )
      .optionallyWith(replicatorState.map(value => value.unwrap))(
        _.replicatorState
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CreateReplicatorResponse.ReadOnly =
    zio.aws.kafka.model.CreateReplicatorResponse.wrap(buildAwsValue())
}
object CreateReplicatorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CreateReplicatorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CreateReplicatorResponse =
      zio.aws.kafka.model.CreateReplicatorResponse(
        replicatorArn.map(value => value),
        replicatorName.map(value => value),
        replicatorState.map(value => value)
      )
    def replicatorArn: Optional[__string]
    def replicatorName: Optional[__string]
    def replicatorState: Optional[zio.aws.kafka.model.ReplicatorState]
    def getReplicatorArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("replicatorArn", replicatorArn)
    def getReplicatorName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("replicatorName", replicatorName)
    def getReplicatorState
        : ZIO[Any, AwsError, zio.aws.kafka.model.ReplicatorState] =
      AwsError.unwrapOptionField("replicatorState", replicatorState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CreateReplicatorResponse
  ) extends zio.aws.kafka.model.CreateReplicatorResponse.ReadOnly {
    override val replicatorArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.replicatorArn())
      .map(value => value: __string)
    override val replicatorName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.replicatorName())
      .map(value => value: __string)
    override val replicatorState
        : Optional[zio.aws.kafka.model.ReplicatorState] = zio.aws.core.internal
      .optionalFromNullable(impl.replicatorState())
      .map(value => zio.aws.kafka.model.ReplicatorState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CreateReplicatorResponse
  ): zio.aws.kafka.model.CreateReplicatorResponse.ReadOnly = new Wrapper(impl)
}
