package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClusterOperationV2Serverless(
    vpcConnectionInfo: Optional[
      zio.aws.kafka.model.VpcConnectionInfoServerless
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ClusterOperationV2Serverless = {
    import ClusterOperationV2Serverless.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ClusterOperationV2Serverless
      .builder()
      .optionallyWith(vpcConnectionInfo.map(value => value.buildAwsValue()))(
        _.vpcConnectionInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ClusterOperationV2Serverless.ReadOnly =
    zio.aws.kafka.model.ClusterOperationV2Serverless.wrap(buildAwsValue())
}
object ClusterOperationV2Serverless {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ClusterOperationV2Serverless
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ClusterOperationV2Serverless =
      zio.aws.kafka.model.ClusterOperationV2Serverless(
        vpcConnectionInfo.map(value => value.asEditable)
      )
    def vpcConnectionInfo
        : Optional[zio.aws.kafka.model.VpcConnectionInfoServerless.ReadOnly]
    def getVpcConnectionInfo: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.VpcConnectionInfoServerless.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConnectionInfo", vpcConnectionInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationV2Serverless
  ) extends zio.aws.kafka.model.ClusterOperationV2Serverless.ReadOnly {
    override val vpcConnectionInfo
        : Optional[zio.aws.kafka.model.VpcConnectionInfoServerless.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConnectionInfo())
        .map(value =>
          zio.aws.kafka.model.VpcConnectionInfoServerless.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationV2Serverless
  ): zio.aws.kafka.model.ClusterOperationV2Serverless.ReadOnly = new Wrapper(
    impl
  )
}
