package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__boolean
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpcConnectivityScram(
    enabled: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.VpcConnectivityScram = {
    import VpcConnectivityScram.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.VpcConnectivityScram
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.VpcConnectivityScram.ReadOnly =
    zio.aws.kafka.model.VpcConnectivityScram.wrap(buildAwsValue())
}
object VpcConnectivityScram {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.VpcConnectivityScram
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.VpcConnectivityScram =
      zio.aws.kafka.model.VpcConnectivityScram(enabled.map(value => value))
    def enabled: Optional[__boolean]
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectivityScram
  ) extends zio.aws.kafka.model.VpcConnectivityScram.ReadOnly {
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectivityScram
  ): zio.aws.kafka.model.VpcConnectivityScram.ReadOnly = new Wrapper(impl)
}
