package zio.aws.kafka.model
import scala.jdk.CollectionConverters.*
sealed trait UserIdentityType {
  def unwrap: software.amazon.awssdk.services.kafka.model.UserIdentityType
}
object UserIdentityType {
  def wrap(
      value: software.amazon.awssdk.services.kafka.model.UserIdentityType
  ): zio.aws.kafka.model.UserIdentityType = value match {
    case software.amazon.awssdk.services.kafka.model.UserIdentityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kafka.model.UserIdentityType.AWSACCOUNT =>
      val r = AWSACCOUNT
      r
    case software.amazon.awssdk.services.kafka.model.UserIdentityType.AWSSERVICE =>
      val r = AWSSERVICE
      r
  }
  case object unknownToSdkVersion extends zio.aws.kafka.model.UserIdentityType {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.UserIdentityType =
      software.amazon.awssdk.services.kafka.model.UserIdentityType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWSACCOUNT extends zio.aws.kafka.model.UserIdentityType {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.UserIdentityType =
      software.amazon.awssdk.services.kafka.model.UserIdentityType.AWSACCOUNT
  }
  case object AWSSERVICE extends zio.aws.kafka.model.UserIdentityType {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.UserIdentityType =
      software.amazon.awssdk.services.kafka.model.UserIdentityType.AWSSERVICE
  }
}
