package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReplicationStateInfo(
    code: Optional[__string] = Optional.Absent,
    message: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ReplicationStateInfo = {
    import ReplicationStateInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ReplicationStateInfo
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ReplicationStateInfo.ReadOnly =
    zio.aws.kafka.model.ReplicationStateInfo.wrap(buildAwsValue())
}
object ReplicationStateInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ReplicationStateInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ReplicationStateInfo =
      zio.aws.kafka.model.ReplicationStateInfo(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[__string]
    def message: Optional[__string]
    def getCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ReplicationStateInfo
  ) extends zio.aws.kafka.model.ReplicationStateInfo.ReadOnly {
    override val code: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: __string)
    override val message: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ReplicationStateInfo
  ): zio.aws.kafka.model.ReplicationStateInfo.ReadOnly = new Wrapper(impl)
}
