package zio.aws.kafka.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__string, MaxResults}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListReplicatorsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    replicatorNameFilter: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest = {
    import ListReplicatorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        replicatorNameFilter.map(value => value: java.lang.String)
      )(_.replicatorNameFilter)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListReplicatorsRequest.ReadOnly =
    zio.aws.kafka.model.ListReplicatorsRequest.wrap(buildAwsValue())
}
object ListReplicatorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListReplicatorsRequest =
      zio.aws.kafka.model.ListReplicatorsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        replicatorNameFilter.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def replicatorNameFilter: Optional[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReplicatorNameFilter: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("replicatorNameFilter", replicatorNameFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest
  ) extends zio.aws.kafka.model.ListReplicatorsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.kafka.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val replicatorNameFilter: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicatorNameFilter())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest
  ): zio.aws.kafka.model.ListReplicatorsRequest.ReadOnly = new Wrapper(impl)
}
