package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class KafkaClusterClientVpcConfig(
    securityGroupIds: Optional[Iterable[__string]] = Optional.Absent,
    subnetIds: Iterable[__string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.KafkaClusterClientVpcConfig = {
    import KafkaClusterClientVpcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.KafkaClusterClientVpcConfig
      .builder()
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.KafkaClusterClientVpcConfig.ReadOnly =
    zio.aws.kafka.model.KafkaClusterClientVpcConfig.wrap(buildAwsValue())
}
object KafkaClusterClientVpcConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.KafkaClusterClientVpcConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.KafkaClusterClientVpcConfig =
      zio.aws.kafka.model.KafkaClusterClientVpcConfig(
        securityGroupIds.map(value => value),
        subnetIds
      )
    def securityGroupIds: Optional[List[__string]]
    def subnetIds: List[__string]
    def getSecurityGroupIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.KafkaClusterClientVpcConfig
  ) extends zio.aws.kafka.model.KafkaClusterClientVpcConfig.ReadOnly {
    override val securityGroupIds: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val subnetIds: List[__string] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.KafkaClusterClientVpcConfig
  ): zio.aws.kafka.model.KafkaClusterClientVpcConfig.ReadOnly = new Wrapper(
    impl
  )
}
