package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetClusterPolicyResponse(
    currentVersion: Optional[__string] = Optional.Absent,
    policy: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.GetClusterPolicyResponse = {
    import GetClusterPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.GetClusterPolicyResponse
      .builder()
      .optionallyWith(currentVersion.map(value => value: java.lang.String))(
        _.currentVersion
      )
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.GetClusterPolicyResponse.ReadOnly =
    zio.aws.kafka.model.GetClusterPolicyResponse.wrap(buildAwsValue())
}
object GetClusterPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.GetClusterPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.GetClusterPolicyResponse =
      zio.aws.kafka.model.GetClusterPolicyResponse(
        currentVersion.map(value => value),
        policy.map(value => value)
      )
    def currentVersion: Optional[__string]
    def policy: Optional[__string]
    def getCurrentVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getPolicy: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.GetClusterPolicyResponse
  ) extends zio.aws.kafka.model.GetClusterPolicyResponse.ReadOnly {
    override val currentVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.currentVersion())
      .map(value => value: __string)
    override val policy: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.GetClusterPolicyResponse
  ): zio.aws.kafka.model.GetClusterPolicyResponse.ReadOnly = new Wrapper(impl)
}
