package zio.aws.kafka.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__boolean, __string, __timestampIso8601}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeReplicatorResponse(
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    currentVersion: Optional[__string] = Optional.Absent,
    isReplicatorReference: Optional[__boolean] = Optional.Absent,
    kafkaClusters: Optional[
      Iterable[zio.aws.kafka.model.KafkaClusterDescription]
    ] = Optional.Absent,
    replicationInfoList: Optional[
      Iterable[zio.aws.kafka.model.ReplicationInfoDescription]
    ] = Optional.Absent,
    replicatorArn: Optional[__string] = Optional.Absent,
    replicatorDescription: Optional[__string] = Optional.Absent,
    replicatorName: Optional[__string] = Optional.Absent,
    replicatorResourceArn: Optional[__string] = Optional.Absent,
    replicatorState: Optional[zio.aws.kafka.model.ReplicatorState] =
      Optional.Absent,
    serviceExecutionRoleArn: Optional[__string] = Optional.Absent,
    stateInfo: Optional[zio.aws.kafka.model.ReplicationStateInfo] =
      Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DescribeReplicatorResponse = {
    import DescribeReplicatorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DescribeReplicatorResponse
      .builder()
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(currentVersion.map(value => value: java.lang.String))(
        _.currentVersion
      )
      .optionallyWith(
        isReplicatorReference.map(value => value: java.lang.Boolean)
      )(_.isReplicatorReference)
      .optionallyWith(
        kafkaClusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.kafkaClusters)
      .optionallyWith(
        replicationInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationInfoList)
      .optionallyWith(replicatorArn.map(value => value: java.lang.String))(
        _.replicatorArn
      )
      .optionallyWith(
        replicatorDescription.map(value => value: java.lang.String)
      )(_.replicatorDescription)
      .optionallyWith(replicatorName.map(value => value: java.lang.String))(
        _.replicatorName
      )
      .optionallyWith(
        replicatorResourceArn.map(value => value: java.lang.String)
      )(_.replicatorResourceArn)
      .optionallyWith(replicatorState.map(value => value.unwrap))(
        _.replicatorState
      )
      .optionallyWith(
        serviceExecutionRoleArn.map(value => value: java.lang.String)
      )(_.serviceExecutionRoleArn)
      .optionallyWith(stateInfo.map(value => value.buildAwsValue()))(
        _.stateInfo
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.DescribeReplicatorResponse.ReadOnly =
    zio.aws.kafka.model.DescribeReplicatorResponse.wrap(buildAwsValue())
}
object DescribeReplicatorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DescribeReplicatorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DescribeReplicatorResponse =
      zio.aws.kafka.model.DescribeReplicatorResponse(
        creationTime.map(value => value),
        currentVersion.map(value => value),
        isReplicatorReference.map(value => value),
        kafkaClusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicationInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicatorArn.map(value => value),
        replicatorDescription.map(value => value),
        replicatorName.map(value => value),
        replicatorResourceArn.map(value => value),
        replicatorState.map(value => value),
        serviceExecutionRoleArn.map(value => value),
        stateInfo.map(value => value.asEditable),
        tags.map(value => value)
      )
    def creationTime: Optional[__timestampIso8601]
    def currentVersion: Optional[__string]
    def isReplicatorReference: Optional[__boolean]
    def kafkaClusters
        : Optional[List[zio.aws.kafka.model.KafkaClusterDescription.ReadOnly]]
    def replicationInfoList: Optional[
      List[zio.aws.kafka.model.ReplicationInfoDescription.ReadOnly]
    ]
    def replicatorArn: Optional[__string]
    def replicatorDescription: Optional[__string]
    def replicatorName: Optional[__string]
    def replicatorResourceArn: Optional[__string]
    def replicatorState: Optional[zio.aws.kafka.model.ReplicatorState]
    def serviceExecutionRoleArn: Optional[__string]
    def stateInfo: Optional[zio.aws.kafka.model.ReplicationStateInfo.ReadOnly]
    def tags: Optional[Map[__string, __string]]
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCurrentVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getIsReplicatorReference: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("isReplicatorReference", isReplicatorReference)
    def getKafkaClusters: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.KafkaClusterDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("kafkaClusters", kafkaClusters)
    def getReplicationInfoList: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.ReplicationInfoDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("replicationInfoList", replicationInfoList)
    def getReplicatorArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("replicatorArn", replicatorArn)
    def getReplicatorDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("replicatorDescription", replicatorDescription)
    def getReplicatorName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("replicatorName", replicatorName)
    def getReplicatorResourceArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("replicatorResourceArn", replicatorResourceArn)
    def getReplicatorState
        : ZIO[Any, AwsError, zio.aws.kafka.model.ReplicatorState] =
      AwsError.unwrapOptionField("replicatorState", replicatorState)
    def getServiceExecutionRoleArn: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("serviceExecutionRoleArn", serviceExecutionRoleArn)
    def getStateInfo: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ReplicationStateInfo.ReadOnly
    ] = AwsError.unwrapOptionField("stateInfo", stateInfo)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DescribeReplicatorResponse
  ) extends zio.aws.kafka.model.DescribeReplicatorResponse.ReadOnly {
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val currentVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.currentVersion())
      .map(value => value: __string)
    override val isReplicatorReference: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isReplicatorReference())
        .map(value => value: __boolean)
    override val kafkaClusters
        : Optional[List[zio.aws.kafka.model.KafkaClusterDescription.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kafkaClusters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.KafkaClusterDescription.wrap(item)
          }.toList
        )
    override val replicationInfoList: Optional[
      List[zio.aws.kafka.model.ReplicationInfoDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationInfoList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kafka.model.ReplicationInfoDescription.wrap(item)
        }.toList
      )
    override val replicatorArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.replicatorArn())
      .map(value => value: __string)
    override val replicatorDescription: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicatorDescription())
        .map(value => value: __string)
    override val replicatorName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.replicatorName())
      .map(value => value: __string)
    override val replicatorResourceArn: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicatorResourceArn())
        .map(value => value: __string)
    override val replicatorState
        : Optional[zio.aws.kafka.model.ReplicatorState] = zio.aws.core.internal
      .optionalFromNullable(impl.replicatorState())
      .map(value => zio.aws.kafka.model.ReplicatorState.wrap(value))
    override val serviceExecutionRoleArn: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceExecutionRoleArn())
        .map(value => value: __string)
    override val stateInfo
        : Optional[zio.aws.kafka.model.ReplicationStateInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateInfo())
        .map(value => zio.aws.kafka.model.ReplicationStateInfo.wrap(value))
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DescribeReplicatorResponse
  ): zio.aws.kafka.model.DescribeReplicatorResponse.ReadOnly = new Wrapper(impl)
}
