package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteVpcConnectionResponse(
    vpcConnectionArn: Optional[__string] = Optional.Absent,
    state: Optional[zio.aws.kafka.model.VpcConnectionState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DeleteVpcConnectionResponse = {
    import DeleteVpcConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DeleteVpcConnectionResponse
      .builder()
      .optionallyWith(vpcConnectionArn.map(value => value: java.lang.String))(
        _.vpcConnectionArn
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.DeleteVpcConnectionResponse.ReadOnly =
    zio.aws.kafka.model.DeleteVpcConnectionResponse.wrap(buildAwsValue())
}
object DeleteVpcConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DeleteVpcConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DeleteVpcConnectionResponse =
      zio.aws.kafka.model.DeleteVpcConnectionResponse(
        vpcConnectionArn.map(value => value),
        state.map(value => value)
      )
    def vpcConnectionArn: Optional[__string]
    def state: Optional[zio.aws.kafka.model.VpcConnectionState]
    def getVpcConnectionArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("vpcConnectionArn", vpcConnectionArn)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.VpcConnectionState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DeleteVpcConnectionResponse
  ) extends zio.aws.kafka.model.DeleteVpcConnectionResponse.ReadOnly {
    override val vpcConnectionArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcConnectionArn())
      .map(value => value: __string)
    override val state: Optional[zio.aws.kafka.model.VpcConnectionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.kafka.model.VpcConnectionState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DeleteVpcConnectionResponse
  ): zio.aws.kafka.model.DeleteVpcConnectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
