package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CompatibleKafkaVersion(
    sourceVersion: Optional[__string] = Optional.Absent,
    targetVersions: Optional[Iterable[__string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CompatibleKafkaVersion = {
    import CompatibleKafkaVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CompatibleKafkaVersion
      .builder()
      .optionallyWith(sourceVersion.map(value => value: java.lang.String))(
        _.sourceVersion
      )
      .optionallyWith(
        targetVersions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.targetVersions)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CompatibleKafkaVersion.ReadOnly =
    zio.aws.kafka.model.CompatibleKafkaVersion.wrap(buildAwsValue())
}
object CompatibleKafkaVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CompatibleKafkaVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CompatibleKafkaVersion =
      zio.aws.kafka.model.CompatibleKafkaVersion(
        sourceVersion.map(value => value),
        targetVersions.map(value => value)
      )
    def sourceVersion: Optional[__string]
    def targetVersions: Optional[List[__string]]
    def getSourceVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
    def getTargetVersions: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("targetVersions", targetVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CompatibleKafkaVersion
  ) extends zio.aws.kafka.model.CompatibleKafkaVersion.ReadOnly {
    override val sourceVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceVersion())
      .map(value => value: __string)
    override val targetVersions: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetVersions())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CompatibleKafkaVersion
  ): zio.aws.kafka.model.CompatibleKafkaVersion.ReadOnly = new Wrapper(impl)
}
