package zio.aws.kafka.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__integer, __timestampIso8601, __string}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ClusterInfo(
    activeOperationArn: Optional[__string] = Optional.Absent,
    brokerNodeGroupInfo: Optional[zio.aws.kafka.model.BrokerNodeGroupInfo] =
      Optional.Absent,
    clientAuthentication: Optional[zio.aws.kafka.model.ClientAuthentication] =
      Optional.Absent,
    clusterArn: Optional[__string] = Optional.Absent,
    clusterName: Optional[__string] = Optional.Absent,
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    currentBrokerSoftwareInfo: Optional[
      zio.aws.kafka.model.BrokerSoftwareInfo
    ] = Optional.Absent,
    currentVersion: Optional[__string] = Optional.Absent,
    encryptionInfo: Optional[zio.aws.kafka.model.EncryptionInfo] =
      Optional.Absent,
    enhancedMonitoring: Optional[zio.aws.kafka.model.EnhancedMonitoring] =
      Optional.Absent,
    openMonitoring: Optional[zio.aws.kafka.model.OpenMonitoring] =
      Optional.Absent,
    loggingInfo: Optional[zio.aws.kafka.model.LoggingInfo] = Optional.Absent,
    numberOfBrokerNodes: Optional[__integer] = Optional.Absent,
    state: Optional[zio.aws.kafka.model.ClusterState] = Optional.Absent,
    stateInfo: Optional[zio.aws.kafka.model.StateInfo] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    zookeeperConnectString: Optional[__string] = Optional.Absent,
    zookeeperConnectStringTls: Optional[__string] = Optional.Absent,
    storageMode: Optional[zio.aws.kafka.model.StorageMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ClusterInfo = {
    import ClusterInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ClusterInfo
      .builder()
      .optionallyWith(activeOperationArn.map(value => value: java.lang.String))(
        _.activeOperationArn
      )
      .optionallyWith(brokerNodeGroupInfo.map(value => value.buildAwsValue()))(
        _.brokerNodeGroupInfo
      )
      .optionallyWith(clientAuthentication.map(value => value.buildAwsValue()))(
        _.clientAuthentication
      )
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(
        currentBrokerSoftwareInfo.map(value => value.buildAwsValue())
      )(_.currentBrokerSoftwareInfo)
      .optionallyWith(currentVersion.map(value => value: java.lang.String))(
        _.currentVersion
      )
      .optionallyWith(encryptionInfo.map(value => value.buildAwsValue()))(
        _.encryptionInfo
      )
      .optionallyWith(enhancedMonitoring.map(value => value.unwrap))(
        _.enhancedMonitoring
      )
      .optionallyWith(openMonitoring.map(value => value.buildAwsValue()))(
        _.openMonitoring
      )
      .optionallyWith(loggingInfo.map(value => value.buildAwsValue()))(
        _.loggingInfo
      )
      .optionallyWith(numberOfBrokerNodes.map(value => value: Integer))(
        _.numberOfBrokerNodes
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateInfo.map(value => value.buildAwsValue()))(
        _.stateInfo
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        zookeeperConnectString.map(value => value: java.lang.String)
      )(_.zookeeperConnectString)
      .optionallyWith(
        zookeeperConnectStringTls.map(value => value: java.lang.String)
      )(_.zookeeperConnectStringTls)
      .optionallyWith(storageMode.map(value => value.unwrap))(_.storageMode)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ClusterInfo.ReadOnly =
    zio.aws.kafka.model.ClusterInfo.wrap(buildAwsValue())
}
object ClusterInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.ClusterInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ClusterInfo =
      zio.aws.kafka.model.ClusterInfo(
        activeOperationArn.map(value => value),
        brokerNodeGroupInfo.map(value => value.asEditable),
        clientAuthentication.map(value => value.asEditable),
        clusterArn.map(value => value),
        clusterName.map(value => value),
        creationTime.map(value => value),
        currentBrokerSoftwareInfo.map(value => value.asEditable),
        currentVersion.map(value => value),
        encryptionInfo.map(value => value.asEditable),
        enhancedMonitoring.map(value => value),
        openMonitoring.map(value => value.asEditable),
        loggingInfo.map(value => value.asEditable),
        numberOfBrokerNodes.map(value => value),
        state.map(value => value),
        stateInfo.map(value => value.asEditable),
        tags.map(value => value),
        zookeeperConnectString.map(value => value),
        zookeeperConnectStringTls.map(value => value),
        storageMode.map(value => value)
      )
    def activeOperationArn: Optional[__string]
    def brokerNodeGroupInfo
        : Optional[zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly]
    def clientAuthentication
        : Optional[zio.aws.kafka.model.ClientAuthentication.ReadOnly]
    def clusterArn: Optional[__string]
    def clusterName: Optional[__string]
    def creationTime: Optional[__timestampIso8601]
    def currentBrokerSoftwareInfo
        : Optional[zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly]
    def currentVersion: Optional[__string]
    def encryptionInfo: Optional[zio.aws.kafka.model.EncryptionInfo.ReadOnly]
    def enhancedMonitoring: Optional[zio.aws.kafka.model.EnhancedMonitoring]
    def openMonitoring: Optional[zio.aws.kafka.model.OpenMonitoring.ReadOnly]
    def loggingInfo: Optional[zio.aws.kafka.model.LoggingInfo.ReadOnly]
    def numberOfBrokerNodes: Optional[__integer]
    def state: Optional[zio.aws.kafka.model.ClusterState]
    def stateInfo: Optional[zio.aws.kafka.model.StateInfo.ReadOnly]
    def tags: Optional[Map[__string, __string]]
    def zookeeperConnectString: Optional[__string]
    def zookeeperConnectStringTls: Optional[__string]
    def storageMode: Optional[zio.aws.kafka.model.StorageMode]
    def getActiveOperationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("activeOperationArn", activeOperationArn)
    def getBrokerNodeGroupInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly] =
      AwsError.unwrapOptionField("brokerNodeGroupInfo", brokerNodeGroupInfo)
    def getClientAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ClientAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("clientAuthentication", clientAuthentication)
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCurrentBrokerSoftwareInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly] =
      AwsError.unwrapOptionField(
        "currentBrokerSoftwareInfo",
        currentBrokerSoftwareInfo
      )
    def getCurrentVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getEncryptionInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.EncryptionInfo.ReadOnly] =
      AwsError.unwrapOptionField("encryptionInfo", encryptionInfo)
    def getEnhancedMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.EnhancedMonitoring] =
      AwsError.unwrapOptionField("enhancedMonitoring", enhancedMonitoring)
    def getOpenMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.OpenMonitoring.ReadOnly] =
      AwsError.unwrapOptionField("openMonitoring", openMonitoring)
    def getLoggingInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      AwsError.unwrapOptionField("loggingInfo", loggingInfo)
    def getNumberOfBrokerNodes: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("numberOfBrokerNodes", numberOfBrokerNodes)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.ClusterState] =
      AwsError.unwrapOptionField("state", state)
    def getStateInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.StateInfo.ReadOnly] =
      AwsError.unwrapOptionField("stateInfo", stateInfo)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getZookeeperConnectString: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("zookeeperConnectString", zookeeperConnectString)
    def getZookeeperConnectStringTls: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("zookeeperConnectStringTls", zookeeperConnectStringTls)
    def getStorageMode: ZIO[Any, AwsError, zio.aws.kafka.model.StorageMode] =
      AwsError.unwrapOptionField("storageMode", storageMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ClusterInfo
  ) extends zio.aws.kafka.model.ClusterInfo.ReadOnly {
    override val activeOperationArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.activeOperationArn())
      .map(value => value: __string)
    override val brokerNodeGroupInfo
        : Optional[zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.brokerNodeGroupInfo())
        .map(value => zio.aws.kafka.model.BrokerNodeGroupInfo.wrap(value))
    override val clientAuthentication
        : Optional[zio.aws.kafka.model.ClientAuthentication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientAuthentication())
        .map(value => zio.aws.kafka.model.ClientAuthentication.wrap(value))
    override val clusterArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: __string)
    override val clusterName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => value: __string)
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val currentBrokerSoftwareInfo
        : Optional[zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentBrokerSoftwareInfo())
        .map(value => zio.aws.kafka.model.BrokerSoftwareInfo.wrap(value))
    override val currentVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.currentVersion())
      .map(value => value: __string)
    override val encryptionInfo
        : Optional[zio.aws.kafka.model.EncryptionInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionInfo())
        .map(value => zio.aws.kafka.model.EncryptionInfo.wrap(value))
    override val enhancedMonitoring
        : Optional[zio.aws.kafka.model.EnhancedMonitoring] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enhancedMonitoring())
        .map(value => zio.aws.kafka.model.EnhancedMonitoring.wrap(value))
    override val openMonitoring
        : Optional[zio.aws.kafka.model.OpenMonitoring.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openMonitoring())
        .map(value => zio.aws.kafka.model.OpenMonitoring.wrap(value))
    override val loggingInfo
        : Optional[zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingInfo())
        .map(value => zio.aws.kafka.model.LoggingInfo.wrap(value))
    override val numberOfBrokerNodes: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfBrokerNodes())
        .map(value => value: __integer)
    override val state: Optional[zio.aws.kafka.model.ClusterState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.kafka.model.ClusterState.wrap(value))
    override val stateInfo: Optional[zio.aws.kafka.model.StateInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateInfo())
        .map(value => zio.aws.kafka.model.StateInfo.wrap(value))
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val zookeeperConnectString: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.zookeeperConnectString())
        .map(value => value: __string)
    override val zookeeperConnectStringTls: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.zookeeperConnectStringTls())
        .map(value => value: __string)
    override val storageMode: Optional[zio.aws.kafka.model.StorageMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageMode())
        .map(value => zio.aws.kafka.model.StorageMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ClusterInfo
  ): zio.aws.kafka.model.ClusterInfo.ReadOnly = new Wrapper(impl)
}
