package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__boolean
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpcConnectivityIam(
    enabled: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.VpcConnectivityIam = {
    import VpcConnectivityIam.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.VpcConnectivityIam
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.VpcConnectivityIam.ReadOnly =
    zio.aws.kafka.model.VpcConnectivityIam.wrap(buildAwsValue())
}
object VpcConnectivityIam {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.VpcConnectivityIam
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.VpcConnectivityIam =
      zio.aws.kafka.model.VpcConnectivityIam(enabled.map(value => value))
    def enabled: Optional[__boolean]
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectivityIam
  ) extends zio.aws.kafka.model.VpcConnectivityIam.ReadOnly {
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectivityIam
  ): zio.aws.kafka.model.VpcConnectivityIam.ReadOnly = new Wrapper(impl)
}
