package zio.aws.kafka.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__integer, __string}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class BrokerEBSVolumeInfo(
    kafkaBrokerNodeId: __string,
    provisionedThroughput: Optional[zio.aws.kafka.model.ProvisionedThroughput] =
      Optional.Absent,
    volumeSizeGB: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo = {
    import BrokerEBSVolumeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo
      .builder()
      .kafkaBrokerNodeId(kafkaBrokerNodeId: java.lang.String)
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .optionallyWith(volumeSizeGB.map(value => value: Integer))(_.volumeSizeGB)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.BrokerEBSVolumeInfo.ReadOnly =
    zio.aws.kafka.model.BrokerEBSVolumeInfo.wrap(buildAwsValue())
}
object BrokerEBSVolumeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.BrokerEBSVolumeInfo =
      zio.aws.kafka.model.BrokerEBSVolumeInfo(
        kafkaBrokerNodeId,
        provisionedThroughput.map(value => value.asEditable),
        volumeSizeGB.map(value => value)
      )
    def kafkaBrokerNodeId: __string
    def provisionedThroughput
        : Optional[zio.aws.kafka.model.ProvisionedThroughput.ReadOnly]
    def volumeSizeGB: Optional[__integer]
    def getKafkaBrokerNodeId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(kafkaBrokerNodeId)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ProvisionedThroughput.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
    def getVolumeSizeGB: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("volumeSizeGB", volumeSizeGB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo
  ) extends zio.aws.kafka.model.BrokerEBSVolumeInfo.ReadOnly {
    override val kafkaBrokerNodeId: __string =
      impl.kafkaBrokerNodeId(): __string
    override val provisionedThroughput
        : Optional[zio.aws.kafka.model.ProvisionedThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedThroughput())
        .map(value => zio.aws.kafka.model.ProvisionedThroughput.wrap(value))
    override val volumeSizeGB: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSizeGB())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo
  ): zio.aws.kafka.model.BrokerEBSVolumeInfo.ReadOnly = new Wrapper(impl)
}
