package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__boolean
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpcConnectivityTls(
    enabled: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.VpcConnectivityTls = {
    import VpcConnectivityTls.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.VpcConnectivityTls
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.VpcConnectivityTls.ReadOnly =
    zio.aws.kafka.model.VpcConnectivityTls.wrap(buildAwsValue())
}
object VpcConnectivityTls {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.VpcConnectivityTls
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.VpcConnectivityTls =
      zio.aws.kafka.model.VpcConnectivityTls(enabled.map(value => value))
    def enabled: Optional[__boolean]
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectivityTls
  ) extends zio.aws.kafka.model.VpcConnectivityTls.ReadOnly {
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectivityTls
  ): zio.aws.kafka.model.VpcConnectivityTls.ReadOnly = new Wrapper(impl)
}
