package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateConnectivityRequest(
    clusterArn: __string,
    connectivityInfo: zio.aws.kafka.model.ConnectivityInfo,
    currentVersion: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateConnectivityRequest = {
    import UpdateConnectivityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateConnectivityRequest
      .builder()
      .clusterArn(clusterArn: java.lang.String)
      .connectivityInfo(connectivityInfo.buildAwsValue())
      .currentVersion(currentVersion: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateConnectivityRequest.ReadOnly =
    zio.aws.kafka.model.UpdateConnectivityRequest.wrap(buildAwsValue())
}
object UpdateConnectivityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateConnectivityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateConnectivityRequest =
      zio.aws.kafka.model.UpdateConnectivityRequest(
        clusterArn,
        connectivityInfo.asEditable,
        currentVersion
      )
    def clusterArn: __string
    def connectivityInfo: zio.aws.kafka.model.ConnectivityInfo.ReadOnly
    def currentVersion: __string
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
    def getConnectivityInfo
        : ZIO[Any, Nothing, zio.aws.kafka.model.ConnectivityInfo.ReadOnly] =
      ZIO.succeed(connectivityInfo)
    def getCurrentVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(currentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateConnectivityRequest
  ) extends zio.aws.kafka.model.UpdateConnectivityRequest.ReadOnly {
    override val clusterArn: __string = impl.clusterArn(): __string
    override val connectivityInfo
        : zio.aws.kafka.model.ConnectivityInfo.ReadOnly =
      zio.aws.kafka.model.ConnectivityInfo.wrap(impl.connectivityInfo())
    override val currentVersion: __string = impl.currentVersion(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateConnectivityRequest
  ): zio.aws.kafka.model.UpdateConnectivityRequest.ReadOnly = new Wrapper(impl)
}
