package zio.aws.kafka.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__timestampIso8601, __string}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateVpcConnectionResponse(
    vpcConnectionArn: Optional[__string] = Optional.Absent,
    state: Optional[zio.aws.kafka.model.VpcConnectionState] = Optional.Absent,
    authentication: Optional[__string] = Optional.Absent,
    vpcId: Optional[__string] = Optional.Absent,
    clientSubnets: Optional[Iterable[__string]] = Optional.Absent,
    securityGroups: Optional[Iterable[__string]] = Optional.Absent,
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CreateVpcConnectionResponse = {
    import CreateVpcConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CreateVpcConnectionResponse
      .builder()
      .optionallyWith(vpcConnectionArn.map(value => value: java.lang.String))(
        _.vpcConnectionArn
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(authentication.map(value => value: java.lang.String))(
        _.authentication
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        clientSubnets.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clientSubnets)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CreateVpcConnectionResponse.ReadOnly =
    zio.aws.kafka.model.CreateVpcConnectionResponse.wrap(buildAwsValue())
}
object CreateVpcConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CreateVpcConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CreateVpcConnectionResponse =
      zio.aws.kafka.model.CreateVpcConnectionResponse(
        vpcConnectionArn.map(value => value),
        state.map(value => value),
        authentication.map(value => value),
        vpcId.map(value => value),
        clientSubnets.map(value => value),
        securityGroups.map(value => value),
        creationTime.map(value => value),
        tags.map(value => value)
      )
    def vpcConnectionArn: Optional[__string]
    def state: Optional[zio.aws.kafka.model.VpcConnectionState]
    def authentication: Optional[__string]
    def vpcId: Optional[__string]
    def clientSubnets: Optional[List[__string]]
    def securityGroups: Optional[List[__string]]
    def creationTime: Optional[__timestampIso8601]
    def tags: Optional[Map[__string, __string]]
    def getVpcConnectionArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("vpcConnectionArn", vpcConnectionArn)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.VpcConnectionState] =
      AwsError.unwrapOptionField("state", state)
    def getAuthentication: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("authentication", authentication)
    def getVpcId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getClientSubnets: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("clientSubnets", clientSubnets)
    def getSecurityGroups: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CreateVpcConnectionResponse
  ) extends zio.aws.kafka.model.CreateVpcConnectionResponse.ReadOnly {
    override val vpcConnectionArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcConnectionArn())
      .map(value => value: __string)
    override val state: Optional[zio.aws.kafka.model.VpcConnectionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.kafka.model.VpcConnectionState.wrap(value))
    override val authentication: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.authentication())
      .map(value => value: __string)
    override val vpcId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: __string)
    override val clientSubnets: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.clientSubnets())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val securityGroups: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CreateVpcConnectionResponse
  ): zio.aws.kafka.model.CreateVpcConnectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
