package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateVpcConnectionRequest(
    targetClusterArn: __string,
    authentication: __string,
    vpcId: __string,
    clientSubnets: Iterable[__string],
    securityGroups: Iterable[__string],
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CreateVpcConnectionRequest = {
    import CreateVpcConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CreateVpcConnectionRequest
      .builder()
      .targetClusterArn(targetClusterArn: java.lang.String)
      .authentication(authentication: java.lang.String)
      .vpcId(vpcId: java.lang.String)
      .clientSubnets(clientSubnets.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .securityGroups(securityGroups.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CreateVpcConnectionRequest.ReadOnly =
    zio.aws.kafka.model.CreateVpcConnectionRequest.wrap(buildAwsValue())
}
object CreateVpcConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CreateVpcConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CreateVpcConnectionRequest =
      zio.aws.kafka.model.CreateVpcConnectionRequest(
        targetClusterArn,
        authentication,
        vpcId,
        clientSubnets,
        securityGroups,
        tags.map(value => value)
      )
    def targetClusterArn: __string
    def authentication: __string
    def vpcId: __string
    def clientSubnets: List[__string]
    def securityGroups: List[__string]
    def tags: Optional[Map[__string, __string]]
    def getTargetClusterArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(targetClusterArn)
    def getAuthentication: ZIO[Any, Nothing, __string] =
      ZIO.succeed(authentication)
    def getVpcId: ZIO[Any, Nothing, __string] = ZIO.succeed(vpcId)
    def getClientSubnets: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(clientSubnets)
    def getSecurityGroups: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(securityGroups)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CreateVpcConnectionRequest
  ) extends zio.aws.kafka.model.CreateVpcConnectionRequest.ReadOnly {
    override val targetClusterArn: __string = impl.targetClusterArn(): __string
    override val authentication: __string = impl.authentication(): __string
    override val vpcId: __string = impl.vpcId(): __string
    override val clientSubnets: List[__string] = impl
      .clientSubnets()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val securityGroups: List[__string] = impl
      .securityGroups()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CreateVpcConnectionRequest
  ): zio.aws.kafka.model.CreateVpcConnectionRequest.ReadOnly = new Wrapper(impl)
}
