package zio.aws.kafka.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__timestampIso8601, __string}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ClusterOperationInfo(
    clientRequestId: Optional[__string] = Optional.Absent,
    clusterArn: Optional[__string] = Optional.Absent,
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    endTime: Optional[__timestampIso8601] = Optional.Absent,
    errorInfo: Optional[zio.aws.kafka.model.ErrorInfo] = Optional.Absent,
    operationArn: Optional[__string] = Optional.Absent,
    operationState: Optional[__string] = Optional.Absent,
    operationSteps: Optional[
      Iterable[zio.aws.kafka.model.ClusterOperationStep]
    ] = Optional.Absent,
    operationType: Optional[__string] = Optional.Absent,
    sourceClusterInfo: Optional[zio.aws.kafka.model.MutableClusterInfo] =
      Optional.Absent,
    targetClusterInfo: Optional[zio.aws.kafka.model.MutableClusterInfo] =
      Optional.Absent,
    vpcConnectionInfo: Optional[zio.aws.kafka.model.VpcConnectionInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ClusterOperationInfo = {
    import ClusterOperationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ClusterOperationInfo
      .builder()
      .optionallyWith(clientRequestId.map(value => value: java.lang.String))(
        _.clientRequestId
      )
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(endTime.map(value => value: Instant))(_.endTime)
      .optionallyWith(errorInfo.map(value => value.buildAwsValue()))(
        _.errorInfo
      )
      .optionallyWith(operationArn.map(value => value: java.lang.String))(
        _.operationArn
      )
      .optionallyWith(operationState.map(value => value: java.lang.String))(
        _.operationState
      )
      .optionallyWith(
        operationSteps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operationSteps)
      .optionallyWith(operationType.map(value => value: java.lang.String))(
        _.operationType
      )
      .optionallyWith(sourceClusterInfo.map(value => value.buildAwsValue()))(
        _.sourceClusterInfo
      )
      .optionallyWith(targetClusterInfo.map(value => value.buildAwsValue()))(
        _.targetClusterInfo
      )
      .optionallyWith(vpcConnectionInfo.map(value => value.buildAwsValue()))(
        _.vpcConnectionInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ClusterOperationInfo.ReadOnly =
    zio.aws.kafka.model.ClusterOperationInfo.wrap(buildAwsValue())
}
object ClusterOperationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ClusterOperationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ClusterOperationInfo =
      zio.aws.kafka.model.ClusterOperationInfo(
        clientRequestId.map(value => value),
        clusterArn.map(value => value),
        creationTime.map(value => value),
        endTime.map(value => value),
        errorInfo.map(value => value.asEditable),
        operationArn.map(value => value),
        operationState.map(value => value),
        operationSteps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        operationType.map(value => value),
        sourceClusterInfo.map(value => value.asEditable),
        targetClusterInfo.map(value => value.asEditable),
        vpcConnectionInfo.map(value => value.asEditable)
      )
    def clientRequestId: Optional[__string]
    def clusterArn: Optional[__string]
    def creationTime: Optional[__timestampIso8601]
    def endTime: Optional[__timestampIso8601]
    def errorInfo: Optional[zio.aws.kafka.model.ErrorInfo.ReadOnly]
    def operationArn: Optional[__string]
    def operationState: Optional[__string]
    def operationSteps
        : Optional[List[zio.aws.kafka.model.ClusterOperationStep.ReadOnly]]
    def operationType: Optional[__string]
    def sourceClusterInfo
        : Optional[zio.aws.kafka.model.MutableClusterInfo.ReadOnly]
    def targetClusterInfo
        : Optional[zio.aws.kafka.model.MutableClusterInfo.ReadOnly]
    def vpcConnectionInfo
        : Optional[zio.aws.kafka.model.VpcConnectionInfo.ReadOnly]
    def getClientRequestId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientRequestId", clientRequestId)
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getEndTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getErrorInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ErrorInfo.ReadOnly] =
      AwsError.unwrapOptionField("errorInfo", errorInfo)
    def getOperationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operationArn", operationArn)
    def getOperationState: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operationState", operationState)
    def getOperationSteps: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.ClusterOperationStep.ReadOnly
    ]] = AwsError.unwrapOptionField("operationSteps", operationSteps)
    def getOperationType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operationType", operationType)
    def getSourceClusterInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.MutableClusterInfo.ReadOnly] =
      AwsError.unwrapOptionField("sourceClusterInfo", sourceClusterInfo)
    def getTargetClusterInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.MutableClusterInfo.ReadOnly] =
      AwsError.unwrapOptionField("targetClusterInfo", targetClusterInfo)
    def getVpcConnectionInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.VpcConnectionInfo.ReadOnly] =
      AwsError.unwrapOptionField("vpcConnectionInfo", vpcConnectionInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationInfo
  ) extends zio.aws.kafka.model.ClusterOperationInfo.ReadOnly {
    override val clientRequestId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clientRequestId())
      .map(value => value: __string)
    override val clusterArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: __string)
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val endTime: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => value: __timestampIso8601)
    override val errorInfo: Optional[zio.aws.kafka.model.ErrorInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorInfo())
        .map(value => zio.aws.kafka.model.ErrorInfo.wrap(value))
    override val operationArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.operationArn())
      .map(value => value: __string)
    override val operationState: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.operationState())
      .map(value => value: __string)
    override val operationSteps
        : Optional[List[zio.aws.kafka.model.ClusterOperationStep.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationSteps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.ClusterOperationStep.wrap(item)
          }.toList
        )
    override val operationType: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.operationType())
      .map(value => value: __string)
    override val sourceClusterInfo
        : Optional[zio.aws.kafka.model.MutableClusterInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceClusterInfo())
        .map(value => zio.aws.kafka.model.MutableClusterInfo.wrap(value))
    override val targetClusterInfo
        : Optional[zio.aws.kafka.model.MutableClusterInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetClusterInfo())
        .map(value => zio.aws.kafka.model.MutableClusterInfo.wrap(value))
    override val vpcConnectionInfo
        : Optional[zio.aws.kafka.model.VpcConnectionInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConnectionInfo())
        .map(value => zio.aws.kafka.model.VpcConnectionInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationInfo
  ): zio.aws.kafka.model.ClusterOperationInfo.ReadOnly = new Wrapper(impl)
}
