package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Sasl(
    scram: Optional[zio.aws.kafka.model.Scram] = Optional.Absent,
    iam: Optional[zio.aws.kafka.model.Iam] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.Sasl = {
    import Sasl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.Sasl
      .builder()
      .optionallyWith(scram.map(value => value.buildAwsValue()))(_.scram)
      .optionallyWith(iam.map(value => value.buildAwsValue()))(_.iam)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.Sasl.ReadOnly =
    zio.aws.kafka.model.Sasl.wrap(buildAwsValue())
}
object Sasl {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.Sasl] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.Sasl = zio.aws.kafka.model.Sasl(
      scram.map(value => value.asEditable),
      iam.map(value => value.asEditable)
    )
    def scram: Optional[zio.aws.kafka.model.Scram.ReadOnly]
    def iam: Optional[zio.aws.kafka.model.Iam.ReadOnly]
    def getScram: ZIO[Any, AwsError, zio.aws.kafka.model.Scram.ReadOnly] =
      AwsError.unwrapOptionField("scram", scram)
    def getIam: ZIO[Any, AwsError, zio.aws.kafka.model.Iam.ReadOnly] =
      AwsError.unwrapOptionField("iam", iam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.Sasl
  ) extends zio.aws.kafka.model.Sasl.ReadOnly {
    override val scram: Optional[zio.aws.kafka.model.Scram.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scram())
        .map(value => zio.aws.kafka.model.Scram.wrap(value))
    override val iam: Optional[zio.aws.kafka.model.Iam.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iam())
        .map(value => zio.aws.kafka.model.Iam.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.Sasl
  ): zio.aws.kafka.model.Sasl.ReadOnly = new Wrapper(impl)
}
