package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListNodesResponse(
    nextToken: Optional[__string] = Optional.Absent,
    nodeInfoList: Optional[Iterable[zio.aws.kafka.model.NodeInfo]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListNodesResponse = {
    import ListNodesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListNodesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        nodeInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeInfoList)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListNodesResponse.ReadOnly =
    zio.aws.kafka.model.ListNodesResponse.wrap(buildAwsValue())
}
object ListNodesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListNodesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListNodesResponse =
      zio.aws.kafka.model.ListNodesResponse(
        nextToken.map(value => value),
        nodeInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[__string]
    def nodeInfoList: Optional[List[zio.aws.kafka.model.NodeInfo.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNodeInfoList
        : ZIO[Any, AwsError, List[zio.aws.kafka.model.NodeInfo.ReadOnly]] =
      AwsError.unwrapOptionField("nodeInfoList", nodeInfoList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListNodesResponse
  ) extends zio.aws.kafka.model.ListNodesResponse.ReadOnly {
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val nodeInfoList
        : Optional[List[zio.aws.kafka.model.NodeInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeInfoList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.NodeInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListNodesResponse
  ): zio.aws.kafka.model.ListNodesResponse.ReadOnly = new Wrapper(impl)
}
