package zio.aws.kafka.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__timestampIso8601, __string}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateConfigurationResponse(
    arn: Optional[__string] = Optional.Absent,
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    latestRevision: Optional[zio.aws.kafka.model.ConfigurationRevision] =
      Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    state: Optional[zio.aws.kafka.model.ConfigurationState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CreateConfigurationResponse = {
    import CreateConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CreateConfigurationResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(latestRevision.map(value => value.buildAwsValue()))(
        _.latestRevision
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CreateConfigurationResponse.ReadOnly =
    zio.aws.kafka.model.CreateConfigurationResponse.wrap(buildAwsValue())
}
object CreateConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CreateConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CreateConfigurationResponse =
      zio.aws.kafka.model.CreateConfigurationResponse(
        arn.map(value => value),
        creationTime.map(value => value),
        latestRevision.map(value => value.asEditable),
        name.map(value => value),
        state.map(value => value)
      )
    def arn: Optional[__string]
    def creationTime: Optional[__timestampIso8601]
    def latestRevision
        : Optional[zio.aws.kafka.model.ConfigurationRevision.ReadOnly]
    def name: Optional[__string]
    def state: Optional[zio.aws.kafka.model.ConfigurationState]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLatestRevision: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ConfigurationRevision.ReadOnly
    ] = AwsError.unwrapOptionField("latestRevision", latestRevision)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.ConfigurationState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CreateConfigurationResponse
  ) extends zio.aws.kafka.model.CreateConfigurationResponse.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val latestRevision
        : Optional[zio.aws.kafka.model.ConfigurationRevision.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestRevision())
        .map(value => zio.aws.kafka.model.ConfigurationRevision.wrap(value))
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val state: Optional[zio.aws.kafka.model.ConfigurationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.kafka.model.ConfigurationState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CreateConfigurationResponse
  ): zio.aws.kafka.model.CreateConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
