package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ErrorInfo(
    errorCode: Optional[__string] = Optional.Absent,
    errorString: Optional[__string] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.ErrorInfo = {
    import ErrorInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ErrorInfo
      .builder()
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorString.map(value => value: java.lang.String))(
        _.errorString
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ErrorInfo.ReadOnly =
    zio.aws.kafka.model.ErrorInfo.wrap(buildAwsValue())
}
object ErrorInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.ErrorInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ErrorInfo = zio.aws.kafka.model
      .ErrorInfo(errorCode.map(value => value), errorString.map(value => value))
    def errorCode: Optional[__string]
    def errorString: Optional[__string]
    def getErrorCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorString: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("errorString", errorString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ErrorInfo
  ) extends zio.aws.kafka.model.ErrorInfo.ReadOnly {
    override val errorCode: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: __string)
    override val errorString: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.errorString())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ErrorInfo
  ): zio.aws.kafka.model.ErrorInfo.ReadOnly = new Wrapper(impl)
}
