package zio.aws.kafka.model
import scala.jdk.CollectionConverters.*
sealed trait ClusterState {
  def unwrap: software.amazon.awssdk.services.kafka.model.ClusterState
}
object ClusterState {
  def wrap(
      value: software.amazon.awssdk.services.kafka.model.ClusterState
  ): zio.aws.kafka.model.ClusterState = value match {
    case software.amazon.awssdk.services.kafka.model.ClusterState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kafka.model.ClusterState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.kafka.model.ClusterState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.kafka.model.ClusterState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.kafka.model.ClusterState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.kafka.model.ClusterState.HEALING =>
      val r = HEALING
      r
    case software.amazon.awssdk.services.kafka.model.ClusterState.MAINTENANCE =>
      val r = MAINTENANCE
      r
    case software.amazon.awssdk.services.kafka.model.ClusterState.REBOOTING_BROKER =>
      val r = REBOOTING_BROKER
      r
    case software.amazon.awssdk.services.kafka.model.ClusterState.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion extends zio.aws.kafka.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClusterState =
      software.amazon.awssdk.services.kafka.model.ClusterState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.kafka.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClusterState =
      software.amazon.awssdk.services.kafka.model.ClusterState.ACTIVE
  }
  case object CREATING extends zio.aws.kafka.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClusterState =
      software.amazon.awssdk.services.kafka.model.ClusterState.CREATING
  }
  case object DELETING extends zio.aws.kafka.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClusterState =
      software.amazon.awssdk.services.kafka.model.ClusterState.DELETING
  }
  case object FAILED extends zio.aws.kafka.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClusterState =
      software.amazon.awssdk.services.kafka.model.ClusterState.FAILED
  }
  case object HEALING extends zio.aws.kafka.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClusterState =
      software.amazon.awssdk.services.kafka.model.ClusterState.HEALING
  }
  case object MAINTENANCE extends zio.aws.kafka.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClusterState =
      software.amazon.awssdk.services.kafka.model.ClusterState.MAINTENANCE
  }
  case object REBOOTING_BROKER extends zio.aws.kafka.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClusterState =
      software.amazon.awssdk.services.kafka.model.ClusterState.REBOOTING_BROKER
  }
  case object UPDATING extends zio.aws.kafka.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClusterState =
      software.amazon.awssdk.services.kafka.model.ClusterState.UPDATING
  }
}
