package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__long, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BrokerSoftwareInfo(
    configurationArn: Optional[__string] = Optional.Absent,
    configurationRevision: Optional[__long] = Optional.Absent,
    kafkaVersion: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo = {
    import BrokerSoftwareInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo
      .builder()
      .optionallyWith(configurationArn.map(value => value: java.lang.String))(
        _.configurationArn
      )
      .optionallyWith(
        configurationRevision.map(value => value: java.lang.Long)
      )(_.configurationRevision)
      .optionallyWith(kafkaVersion.map(value => value: java.lang.String))(
        _.kafkaVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly =
    zio.aws.kafka.model.BrokerSoftwareInfo.wrap(buildAwsValue())
}
object BrokerSoftwareInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.BrokerSoftwareInfo =
      zio.aws.kafka.model.BrokerSoftwareInfo(
        configurationArn.map(value => value),
        configurationRevision.map(value => value),
        kafkaVersion.map(value => value)
      )
    def configurationArn: Optional[__string]
    def configurationRevision: Optional[__long]
    def kafkaVersion: Optional[__string]
    def getConfigurationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("configurationArn", configurationArn)
    def getConfigurationRevision: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("configurationRevision", configurationRevision)
    def getKafkaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("kafkaVersion", kafkaVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo
  ) extends zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly {
    override val configurationArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationArn())
      .map(value => value: __string)
    override val configurationRevision: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationRevision())
      .map(value => value: __long)
    override val kafkaVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.kafkaVersion())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo
  ): zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly = new Wrapper(impl)
}
