package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListConfigurationRevisionsResponse(
    nextToken: Optional[__string] = Optional.Absent,
    revisions: Optional[Iterable[zio.aws.kafka.model.ConfigurationRevision]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse = {
    import ListConfigurationRevisionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        revisions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.revisions)
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.ListConfigurationRevisionsResponse.ReadOnly =
    zio.aws.kafka.model.ListConfigurationRevisionsResponse.wrap(buildAwsValue())
}
object ListConfigurationRevisionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListConfigurationRevisionsResponse =
      zio.aws.kafka.model.ListConfigurationRevisionsResponse(
        nextToken.map(value => value),
        revisions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[__string]
    def revisions
        : Optional[List[zio.aws.kafka.model.ConfigurationRevision.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRevisions: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.ConfigurationRevision.ReadOnly
    ]] = AwsError.unwrapOptionField("revisions", revisions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse
  ) extends zio.aws.kafka.model.ListConfigurationRevisionsResponse.ReadOnly {
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val revisions
        : Optional[List[zio.aws.kafka.model.ConfigurationRevision.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revisions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.ConfigurationRevision.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse
  ): zio.aws.kafka.model.ListConfigurationRevisionsResponse.ReadOnly =
    new Wrapper(impl)
}
