package zio.aws.kafka.model
import scala.jdk.CollectionConverters.*
sealed trait KafkaVersionStatus {
  def unwrap: software.amazon.awssdk.services.kafka.model.KafkaVersionStatus
}
object KafkaVersionStatus {
  def wrap(
      value: software.amazon.awssdk.services.kafka.model.KafkaVersionStatus
  ): zio.aws.kafka.model.KafkaVersionStatus = value match {
    case software.amazon.awssdk.services.kafka.model.KafkaVersionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kafka.model.KafkaVersionStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.kafka.model.KafkaVersionStatus.DEPRECATED =>
      val r = DEPRECATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kafka.model.KafkaVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.KafkaVersionStatus =
      software.amazon.awssdk.services.kafka.model.KafkaVersionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.kafka.model.KafkaVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.KafkaVersionStatus =
      software.amazon.awssdk.services.kafka.model.KafkaVersionStatus.ACTIVE
  }
  case object DEPRECATED extends zio.aws.kafka.model.KafkaVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.KafkaVersionStatus =
      software.amazon.awssdk.services.kafka.model.KafkaVersionStatus.DEPRECATED
  }
}
