package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListClusterOperationsResponse(
    clusterOperationInfoList: Optional[
      Iterable[zio.aws.kafka.model.ClusterOperationInfo]
    ] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse = {
    import ListClusterOperationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse
      .builder()
      .optionallyWith(
        clusterOperationInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterOperationInfoList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListClusterOperationsResponse.ReadOnly =
    zio.aws.kafka.model.ListClusterOperationsResponse.wrap(buildAwsValue())
}
object ListClusterOperationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListClusterOperationsResponse =
      zio.aws.kafka.model.ListClusterOperationsResponse(
        clusterOperationInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def clusterOperationInfoList
        : Optional[List[zio.aws.kafka.model.ClusterOperationInfo.ReadOnly]]
    def nextToken: Optional[__string]
    def getClusterOperationInfoList: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.ClusterOperationInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "clusterOperationInfoList",
      clusterOperationInfoList
    )
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse
  ) extends zio.aws.kafka.model.ListClusterOperationsResponse.ReadOnly {
    override val clusterOperationInfoList
        : Optional[List[zio.aws.kafka.model.ClusterOperationInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterOperationInfoList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.ClusterOperationInfo.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse
  ): zio.aws.kafka.model.ListClusterOperationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
