package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateClusterResponse(
    clusterArn: Optional[__string] = Optional.Absent,
    clusterName: Optional[__string] = Optional.Absent,
    state: Optional[zio.aws.kafka.model.ClusterState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CreateClusterResponse = {
    import CreateClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CreateClusterResponse
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CreateClusterResponse.ReadOnly =
    zio.aws.kafka.model.CreateClusterResponse.wrap(buildAwsValue())
}
object CreateClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CreateClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CreateClusterResponse =
      zio.aws.kafka.model.CreateClusterResponse(
        clusterArn.map(value => value),
        clusterName.map(value => value),
        state.map(value => value)
      )
    def clusterArn: Optional[__string]
    def clusterName: Optional[__string]
    def state: Optional[zio.aws.kafka.model.ClusterState]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.ClusterState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CreateClusterResponse
  ) extends zio.aws.kafka.model.CreateClusterResponse.ReadOnly {
    override val clusterArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: __string)
    override val clusterName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => value: __string)
    override val state: Optional[zio.aws.kafka.model.ClusterState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.kafka.model.ClusterState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CreateClusterResponse
  ): zio.aws.kafka.model.CreateClusterResponse.ReadOnly = new Wrapper(impl)
}
