package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpcConfig(
    subnetIds: Iterable[__string],
    securityGroupIds: Optional[Iterable[__string]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.VpcConfig = {
    import VpcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.VpcConfig
      .builder()
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.VpcConfig.ReadOnly =
    zio.aws.kafka.model.VpcConfig.wrap(buildAwsValue())
}
object VpcConfig {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.VpcConfig] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.VpcConfig = zio.aws.kafka.model
      .VpcConfig(subnetIds, securityGroupIds.map(value => value))
    def subnetIds: List[__string]
    def securityGroupIds: Optional[List[__string]]
    def getSubnetIds: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.VpcConfig
  ) extends zio.aws.kafka.model.VpcConfig.ReadOnly {
    override val subnetIds: List[__string] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val securityGroupIds: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.VpcConfig
  ): zio.aws.kafka.model.VpcConfig.ReadOnly = new Wrapper(impl)
}
