package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class KafkaVersion(
    version: Optional[__string] = Optional.Absent,
    status: Optional[zio.aws.kafka.model.KafkaVersionStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.KafkaVersion = {
    import KafkaVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.KafkaVersion
      .builder()
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.KafkaVersion.ReadOnly =
    zio.aws.kafka.model.KafkaVersion.wrap(buildAwsValue())
}
object KafkaVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.KafkaVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.KafkaVersion = zio.aws.kafka.model
      .KafkaVersion(version.map(value => value), status.map(value => value))
    def version: Optional[__string]
    def status: Optional[zio.aws.kafka.model.KafkaVersionStatus]
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
    def getStatus: ZIO[Any, AwsError, zio.aws.kafka.model.KafkaVersionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.KafkaVersion
  ) extends zio.aws.kafka.model.KafkaVersion.ReadOnly {
    override val version: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: __string)
    override val status: Optional[zio.aws.kafka.model.KafkaVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.kafka.model.KafkaVersionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.KafkaVersion
  ): zio.aws.kafka.model.KafkaVersion.ReadOnly = new Wrapper(impl)
}
