package zio.aws.kafka.model
import scala.jdk.CollectionConverters.*
sealed trait NodeType {
  def unwrap: software.amazon.awssdk.services.kafka.model.NodeType
}
object NodeType {
  def wrap(
      value: software.amazon.awssdk.services.kafka.model.NodeType
  ): zio.aws.kafka.model.NodeType = value match {
    case software.amazon.awssdk.services.kafka.model.NodeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kafka.model.NodeType.BROKER =>
      val r = BROKER
      r
  }
  case object unknownToSdkVersion extends zio.aws.kafka.model.NodeType {
    override def unwrap: software.amazon.awssdk.services.kafka.model.NodeType =
      software.amazon.awssdk.services.kafka.model.NodeType.UNKNOWN_TO_SDK_VERSION
  }
  case object BROKER extends zio.aws.kafka.model.NodeType {
    override def unwrap: software.amazon.awssdk.services.kafka.model.NodeType =
      software.amazon.awssdk.services.kafka.model.NodeType.BROKER
  }
}
