package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NodeInfo(
    addedToClusterTime: Optional[__string] = Optional.Absent,
    brokerNodeInfo: Optional[zio.aws.kafka.model.BrokerNodeInfo] =
      Optional.Absent,
    instanceType: Optional[__string] = Optional.Absent,
    nodeARN: Optional[__string] = Optional.Absent,
    nodeType: Optional[zio.aws.kafka.model.NodeType] = Optional.Absent,
    zookeeperNodeInfo: Optional[zio.aws.kafka.model.ZookeeperNodeInfo] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.NodeInfo = {
    import NodeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.NodeInfo
      .builder()
      .optionallyWith(addedToClusterTime.map(value => value: java.lang.String))(
        _.addedToClusterTime
      )
      .optionallyWith(brokerNodeInfo.map(value => value.buildAwsValue()))(
        _.brokerNodeInfo
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(nodeARN.map(value => value: java.lang.String))(_.nodeARN)
      .optionallyWith(nodeType.map(value => value.unwrap))(_.nodeType)
      .optionallyWith(zookeeperNodeInfo.map(value => value.buildAwsValue()))(
        _.zookeeperNodeInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.NodeInfo.ReadOnly =
    zio.aws.kafka.model.NodeInfo.wrap(buildAwsValue())
}
object NodeInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.NodeInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.NodeInfo = zio.aws.kafka.model.NodeInfo(
      addedToClusterTime.map(value => value),
      brokerNodeInfo.map(value => value.asEditable),
      instanceType.map(value => value),
      nodeARN.map(value => value),
      nodeType.map(value => value),
      zookeeperNodeInfo.map(value => value.asEditable)
    )
    def addedToClusterTime: Optional[__string]
    def brokerNodeInfo: Optional[zio.aws.kafka.model.BrokerNodeInfo.ReadOnly]
    def instanceType: Optional[__string]
    def nodeARN: Optional[__string]
    def nodeType: Optional[zio.aws.kafka.model.NodeType]
    def zookeeperNodeInfo
        : Optional[zio.aws.kafka.model.ZookeeperNodeInfo.ReadOnly]
    def getAddedToClusterTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("addedToClusterTime", addedToClusterTime)
    def getBrokerNodeInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.BrokerNodeInfo.ReadOnly] =
      AwsError.unwrapOptionField("brokerNodeInfo", brokerNodeInfo)
    def getInstanceType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getNodeARN: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nodeARN", nodeARN)
    def getNodeType: ZIO[Any, AwsError, zio.aws.kafka.model.NodeType] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getZookeeperNodeInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ZookeeperNodeInfo.ReadOnly] =
      AwsError.unwrapOptionField("zookeeperNodeInfo", zookeeperNodeInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.NodeInfo
  ) extends zio.aws.kafka.model.NodeInfo.ReadOnly {
    override val addedToClusterTime: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.addedToClusterTime())
      .map(value => value: __string)
    override val brokerNodeInfo
        : Optional[zio.aws.kafka.model.BrokerNodeInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.brokerNodeInfo())
        .map(value => zio.aws.kafka.model.BrokerNodeInfo.wrap(value))
    override val instanceType: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: __string)
    override val nodeARN: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeARN())
      .map(value => value: __string)
    override val nodeType: Optional[zio.aws.kafka.model.NodeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeType())
        .map(value => zio.aws.kafka.model.NodeType.wrap(value))
    override val zookeeperNodeInfo
        : Optional[zio.aws.kafka.model.ZookeeperNodeInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.zookeeperNodeInfo())
        .map(value => zio.aws.kafka.model.ZookeeperNodeInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.NodeInfo
  ): zio.aws.kafka.model.NodeInfo.ReadOnly = new Wrapper(impl)
}
