package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClusterOperationStepInfo(
    stepStatus: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ClusterOperationStepInfo = {
    import ClusterOperationStepInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ClusterOperationStepInfo
      .builder()
      .optionallyWith(stepStatus.map(value => value: java.lang.String))(
        _.stepStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ClusterOperationStepInfo.ReadOnly =
    zio.aws.kafka.model.ClusterOperationStepInfo.wrap(buildAwsValue())
}
object ClusterOperationStepInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ClusterOperationStepInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ClusterOperationStepInfo =
      zio.aws.kafka.model
        .ClusterOperationStepInfo(stepStatus.map(value => value))
    def stepStatus: Optional[__string]
    def getStepStatus: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("stepStatus", stepStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationStepInfo
  ) extends zio.aws.kafka.model.ClusterOperationStepInfo.ReadOnly {
    override val stepStatus: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.stepStatus())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationStepInfo
  ): zio.aws.kafka.model.ClusterOperationStepInfo.ReadOnly = new Wrapper(impl)
}
