package zio.aws.kafka.model
import scala.jdk.CollectionConverters.*
sealed trait ClusterType {
  def unwrap: software.amazon.awssdk.services.kafka.model.ClusterType
}
object ClusterType {
  def wrap(
      value: software.amazon.awssdk.services.kafka.model.ClusterType
  ): zio.aws.kafka.model.ClusterType = value match {
    case software.amazon.awssdk.services.kafka.model.ClusterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kafka.model.ClusterType.PROVISIONED =>
      val r = PROVISIONED
      r
    case software.amazon.awssdk.services.kafka.model.ClusterType.SERVERLESS =>
      val r = SERVERLESS
      r
  }
  case object unknownToSdkVersion extends zio.aws.kafka.model.ClusterType {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClusterType =
      software.amazon.awssdk.services.kafka.model.ClusterType.UNKNOWN_TO_SDK_VERSION
  }
  case object PROVISIONED extends zio.aws.kafka.model.ClusterType {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClusterType =
      software.amazon.awssdk.services.kafka.model.ClusterType.PROVISIONED
  }
  case object SERVERLESS extends zio.aws.kafka.model.ClusterType {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClusterType =
      software.amazon.awssdk.services.kafka.model.ClusterType.SERVERLESS
  }
}
