package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteClusterResponse(
    clusterArn: Optional[__string] = Optional.Absent,
    state: Optional[zio.aws.kafka.model.ClusterState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DeleteClusterResponse = {
    import DeleteClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DeleteClusterResponse
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.DeleteClusterResponse.ReadOnly =
    zio.aws.kafka.model.DeleteClusterResponse.wrap(buildAwsValue())
}
object DeleteClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DeleteClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DeleteClusterResponse =
      zio.aws.kafka.model.DeleteClusterResponse(
        clusterArn.map(value => value),
        state.map(value => value)
      )
    def clusterArn: Optional[__string]
    def state: Optional[zio.aws.kafka.model.ClusterState]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.ClusterState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DeleteClusterResponse
  ) extends zio.aws.kafka.model.DeleteClusterResponse.ReadOnly {
    override val clusterArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: __string)
    override val state: Optional[zio.aws.kafka.model.ClusterState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.kafka.model.ClusterState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DeleteClusterResponse
  ): zio.aws.kafka.model.DeleteClusterResponse.ReadOnly = new Wrapper(impl)
}
