package zio.aws.kafka.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__timestampIso8601, __string}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Cluster(
    activeOperationArn: Optional[__string] = Optional.Absent,
    clusterType: Optional[zio.aws.kafka.model.ClusterType] = Optional.Absent,
    clusterArn: Optional[__string] = Optional.Absent,
    clusterName: Optional[__string] = Optional.Absent,
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    currentVersion: Optional[__string] = Optional.Absent,
    state: Optional[zio.aws.kafka.model.ClusterState] = Optional.Absent,
    stateInfo: Optional[zio.aws.kafka.model.StateInfo] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    provisioned: Optional[zio.aws.kafka.model.Provisioned] = Optional.Absent,
    serverless: Optional[zio.aws.kafka.model.Serverless] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.Cluster
      .builder()
      .optionallyWith(activeOperationArn.map(value => value: java.lang.String))(
        _.activeOperationArn
      )
      .optionallyWith(clusterType.map(value => value.unwrap))(_.clusterType)
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(currentVersion.map(value => value: java.lang.String))(
        _.currentVersion
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateInfo.map(value => value.buildAwsValue()))(
        _.stateInfo
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(provisioned.map(value => value.buildAwsValue()))(
        _.provisioned
      )
      .optionallyWith(serverless.map(value => value.buildAwsValue()))(
        _.serverless
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.Cluster.ReadOnly =
    zio.aws.kafka.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.Cluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.Cluster = zio.aws.kafka.model.Cluster(
      activeOperationArn.map(value => value),
      clusterType.map(value => value),
      clusterArn.map(value => value),
      clusterName.map(value => value),
      creationTime.map(value => value),
      currentVersion.map(value => value),
      state.map(value => value),
      stateInfo.map(value => value.asEditable),
      tags.map(value => value),
      provisioned.map(value => value.asEditable),
      serverless.map(value => value.asEditable)
    )
    def activeOperationArn: Optional[__string]
    def clusterType: Optional[zio.aws.kafka.model.ClusterType]
    def clusterArn: Optional[__string]
    def clusterName: Optional[__string]
    def creationTime: Optional[__timestampIso8601]
    def currentVersion: Optional[__string]
    def state: Optional[zio.aws.kafka.model.ClusterState]
    def stateInfo: Optional[zio.aws.kafka.model.StateInfo.ReadOnly]
    def tags: Optional[Map[__string, __string]]
    def provisioned: Optional[zio.aws.kafka.model.Provisioned.ReadOnly]
    def serverless: Optional[zio.aws.kafka.model.Serverless.ReadOnly]
    def getActiveOperationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("activeOperationArn", activeOperationArn)
    def getClusterType: ZIO[Any, AwsError, zio.aws.kafka.model.ClusterType] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCurrentVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.ClusterState] =
      AwsError.unwrapOptionField("state", state)
    def getStateInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.StateInfo.ReadOnly] =
      AwsError.unwrapOptionField("stateInfo", stateInfo)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getProvisioned
        : ZIO[Any, AwsError, zio.aws.kafka.model.Provisioned.ReadOnly] =
      AwsError.unwrapOptionField("provisioned", provisioned)
    def getServerless
        : ZIO[Any, AwsError, zio.aws.kafka.model.Serverless.ReadOnly] =
      AwsError.unwrapOptionField("serverless", serverless)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.Cluster
  ) extends zio.aws.kafka.model.Cluster.ReadOnly {
    override val activeOperationArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.activeOperationArn())
      .map(value => value: __string)
    override val clusterType: Optional[zio.aws.kafka.model.ClusterType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterType())
        .map(value => zio.aws.kafka.model.ClusterType.wrap(value))
    override val clusterArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: __string)
    override val clusterName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => value: __string)
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val currentVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.currentVersion())
      .map(value => value: __string)
    override val state: Optional[zio.aws.kafka.model.ClusterState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.kafka.model.ClusterState.wrap(value))
    override val stateInfo: Optional[zio.aws.kafka.model.StateInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateInfo())
        .map(value => zio.aws.kafka.model.StateInfo.wrap(value))
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val provisioned
        : Optional[zio.aws.kafka.model.Provisioned.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioned())
        .map(value => zio.aws.kafka.model.Provisioned.wrap(value))
    override val serverless: Optional[zio.aws.kafka.model.Serverless.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverless())
        .map(value => zio.aws.kafka.model.Serverless.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.Cluster
  ): zio.aws.kafka.model.Cluster.ReadOnly = new Wrapper(impl)
}
